import React from 'react';
import { Calendar, AlertCircle, TrendingUp } from 'lucide-react';

const InfoCards = ({ analysis }) => {
  return (
    <div className="grid grid-cols-1 lg:grid-cols-3 gap-6">
      <div className="glass rounded-lg p-6">
        <div className="flex items-center mb-4">
          <TrendingUp className="w-5 h-5 mr-2 text-cyan-400" />
          <h3 className="text-lg font-semibold">Key Levels to Watch</h3>
        </div>
        <div className="space-y-3">
          {analysis.keyLevels.map((level, index) => (
            <div key={index} className="flex justify-between items-center p-3 rounded bg-white/5">
              <span className="text-gray-300">{level.description}</span>
              <span className="font-semibold text-cyan-300">${level.price}</span>
            </div>
          ))}
        </div>
      </div>

      <div className="glass rounded-lg p-6">
        <div className="flex items-center mb-4">
          <Calendar className="w-5 h-5 mr-2 text-green-400" />
          <h3 className="text-lg font-semibold">Upcoming Catalysts</h3>
        </div>
        <div className="space-y-3">
          {analysis.upcomingCatalysts.map((catalyst, index) => (
            <div key={index} className="p-3 rounded bg-white/5">
              <div className="flex justify-between items-start mb-1">
                <span className="font-medium text-white">{catalyst.event}</span>
                <span className="text-sm text-gray-400">{catalyst.date}</span>
              </div>
              <p className="text-sm text-gray-300">{catalyst.description}</p>
              {catalyst.impact && (
                <span className={`inline-block mt-2 px-2 py-1 text-xs rounded ${catalyst.impact === 'HIGH' ? 'bg-red-900/40 text-red-300' : catalyst.impact === 'MEDIUM' ? 'bg-amber-900/40 text-amber-300' : 'bg-green-900/40 text-green-300'}`}>
                  {catalyst.impact} Impact
                </span>
              )}
            </div>
          ))}
        </div>
      </div>

      <div className="bg-gradient-to-br from-red-900/20 to-red-900/5 border border-red-900/30 rounded-lg p-6">
        <div className="flex items-center mb-4">
          <AlertCircle className="w-5 h-5 mr-2 text-red-400" />
          <h3 className="text-lg font-semibold">Key Risks</h3>
        </div>
        <div className="space-y-3">
          {analysis.keyRisks.map((risk, index) => (
            <div key={index} className="flex items-start">
              <div className="w-2 h-2 mt-2 mr-3 rounded-full bg-red-400 flex-shrink-0" />
              <div>
                <p className="font-medium text-white mb-1">{risk.title}</p>
                <p className="text-sm text-gray-300">{risk.description}</p>
                <span className={`inline-block mt-2 px-2 py-1 text-xs rounded ${risk.severity === 'HIGH' ? 'bg-red-900/40 text-red-300' : risk.severity === 'MEDIUM' ? 'bg-amber-900/40 text-amber-300' : 'bg-yellow-900/40 text-yellow-300'}`}>
                  {risk.severity} Risk
                </span>
              </div>
            </div>
          ))}
        </div>
      </div>
    </div>
  );
};

export default InfoCards;