import React from 'react';
import { Activity } from 'lucide-react';

const MetricsDisplay = ({ analysis }) => {
  return (
    <div className="mb-8">
      <div className="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
        {Object.entries(analysis.fundamentalMetrics).map(([key, value]) => (
          <div key={key} className="glass rounded-lg p-4">
            <p className="text-sm text-gray-400 capitalize">{key.replace(/([A-Z])/g, ' $1')}</p>
            <p className="text-xl font-semibold">{typeof value === 'number' ? value.toLocaleString() : value}</p>
          </div>
        ))}
      </div>

      <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
        <div className="glass rounded-lg p-6">
          <h3 className="text-lg font-semibold mb-4 flex items-center">
            <Activity className="w-5 h-5 mr-2" />
            Technical Analysis
          </h3>
          <div className="space-y-3">
            <div className="flex justify-between">
              <span>Trend</span>
              <span className={`font-semibold ${analysis.technicalAnalysis.trend === 'Bullish' ? 'text-green-400' : analysis.technicalAnalysis.trend === 'Bearish' ? 'text-red-400' : 'text-gray-400'}`}>
                {analysis.technicalAnalysis.trend}
              </span>
            </div>
            <div className="flex justify-between">
              <span>RSI</span>
              <span className={`font-semibold ${analysis.technicalAnalysis.rsiValue > 70 ? 'text-red-400' : analysis.technicalAnalysis.rsiValue < 30 ? 'text-green-400' : 'text-gray-400'}`}>
                {analysis.technicalAnalysis.rsiValue} ({analysis.technicalAnalysis.rsiStatus})
              </span>
            </div>
            <div className="flex justify-between">
              <span>MACD Signal</span>
              <span className={`font-semibold ${analysis.technicalAnalysis.macdSignal === 'bullish' ? 'text-green-400' : analysis.technicalAnalysis.macdSignal === 'bearish' ? 'text-red-400' : 'text-gray-400'}`}>
                {analysis.technicalAnalysis.macdSignal}
              </span>
            </div>
          </div>
        </div>

        <div className="glass rounded-lg p-6">
          <h3 className="text-lg font-semibold mb-4">Key Levels</h3>
          <div className="space-y-3">
            <div>
              <p className="text-sm text-gray-400">Support</p>
              <p className="text-lg font-semibold text-green-400">${analysis.technicalAnalysis.supportResistance.support}</p>
            </div>
            <div>
              <p className="text-sm text-gray-400">Resistance</p>
              <p className="text-lg font-semibold text-red-400">${analysis.technicalAnalysis.supportResistance.resistance}</p>
            </div>
            <div>
              <p className="text-sm text-gray-400">Price Position</p>
              <p className="text-lg font-semibold">{analysis.technicalAnalysis.pricePositionRelativeToMA}</p>
            </div>
          </div>
        </div>

        <div className="glass rounded-lg p-6">
          <h3 className="text-lg font-semibold mb-4">Bollinger Bands</h3>
          <div className="space-y-3">
            <div className="flex justify-between">
              <span>Upper Band</span>
              <span className="text-red-400">${analysis.bollingerBands.upperBand}</span>
            </div>
            <div className="flex justify-between">
              <span>Middle Band (SMA 20)</span>
              <span>${analysis.bollingerBands.middleBand}</span>
            </div>
            <div className="flex justify-between">
              <span>Lower Band</span>
              <span className="text-green-400">${analysis.bollingerBands.lowerBand}</span>
            </div>
            <div className="flex justify-between">
              <span>Position</span>
              <span className={`font-semibold ${analysis.bollingerBands.currentPosition.includes('upper') ? 'text-red-400' : analysis.bollingerBands.currentPosition.includes('lower') ? 'text-green-400' : 'text-gray-400'}`}>
                {analysis.bollingerBands.currentPosition}
              </span>
            </div>
            <div className="flex justify-between">
              <span>Squeeze Detection</span>
              <span className={`font-semibold ${analysis.bollingerBands.squeezeDetection ? 'text-amber-400' : 'text-gray-400'}`}>
                {analysis.bollingerBands.squeezeDetection ? 'YES' : 'NO'}
              </span>
            </div>
          </div>
        </div>
      </div>

      <div className="grid grid-cols-3 gap-4">
        {Object.entries(analysis.technicalAnalysis.movingAverages).map(([key, value]) => (
          <div key={key} className="glass rounded-lg p-4 text-center">
            <p className="text-sm text-gray-400">SMA {key.replace('sma', '')}</p>
            <p className="text-xl font-semibold">${value}</p>
          </div>
        ))}
      </div>
    </div>
  );
};

export default MetricsDisplay;