import React, { useState } from 'react';
import { TrendingUp, TrendingDown, DollarSign, Activity } from 'lucide-react';

const StrategyTabs = ({ strategies }) => {
  const [activeTab, setActiveTab] = useState('wheel');

  const tabs = [
    { id: 'wheel', label: 'Wheel Strategy', icon: <DollarSign className="w-4 h-4" /> },
    { id: 'directional', label: 'Directional Plays', icon: <Activity className="w-4 h-4" /> },
    { id: 'spreads', label: 'Credit Spreads', icon: <TrendingUp className="w-4 h-4" /> },
  ];

  const RecommendationBadge = ({ status }) => (
    <span className={`px-3 py-1 rounded-full text-sm font-semibold ${status === 'RECOMMENDED' ? 'bg-green-900/40 text-green-300' : 'bg-gray-700 text-gray-300'}`}>
      {status}
    </span>
  );

  const ConfidenceBadge = ({ level }) => {
    const colors = {
      HIGH: 'bg-green-900/40 text-green-300',
      MEDIUM: 'bg-amber-900/40 text-amber-300',
      LOW: 'bg-red-900/40 text-red-300'
    };
    return (
      <span className={`px-3 py-1 rounded-full text-sm font-semibold ${colors[level]}`}>
        {level} Confidence
      </span>
    );
  };

  return (
    <div className="mb-8">
      <div className="flex border-b border-white/10 mb-6 overflow-x-auto">
        {tabs.map(tab => (
          <button
            key={tab.id}
            onClick={() => setActiveTab(tab.id)}
            className={`flex items-center px-6 py-3 font-medium transition-all whitespace-nowrap ${activeTab === tab.id ? 'border-b-2 border-cyan-400 text-cyan-400' : 'text-gray-400 hover:text-white'}`}
          >
            {tab.icon}
            <span className="ml-2">{tab.label}</span>
          </button>
        ))}
      </div>

      <div className="glass rounded-lg p-6">
        {activeTab === 'wheel' && (
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <div className="bg-gradient-to-br from-green-900/20 to-green-900/5 border border-green-900/30 rounded-lg p-6">
              <div className="flex items-center justify-between mb-4">
                <h3 className="text-xl font-bold text-green-400">SELL PUT</h3>
                <RecommendationBadge status={strategies.wheelStrategy.sellPut.recommendation} />
              </div>
              <div className="space-y-4">
                <div>
                  <p className="text-sm text-gray-400 mb-1">Reasoning</p>
                  <p className="text-gray-300">{strategies.wheelStrategy.sellPut.reasoning}</p>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Suggested Strike</p>
                    <p className="text-lg font-semibold">${strategies.wheelStrategy.sellPut.suggestedStrikePrice}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Target Delta</p>
                    <p className="text-lg font-semibold">{strategies.wheelStrategy.sellPut.targetDelta}</p>
                  </div>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Estimated Premium</p>
                    <p className="text-lg font-semibold">${strategies.wheelStrategy.sellPut.estimatedPremium}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Assignment Risk</p>
                    <p className={`text-lg font-semibold ${strategies.wheelStrategy.sellPut.assignmentRisk === 'LOW' ? 'text-green-400' : strategies.wheelStrategy.sellPut.assignmentRisk === 'MEDIUM' ? 'text-amber-400' : 'text-red-400'}`}>
                      {strategies.wheelStrategy.sellPut.assignmentRisk}
                    </p>
                  </div>
                </div>
                <div className="pt-4 border-t border-white/10">
                  <ConfidenceBadge level={strategies.wheelStrategy.sellPut.confidenceLevel} />
                </div>
              </div>
            </div>

            <div className="bg-gradient-to-br from-red-900/20 to-red-900/5 border border-red-900/30 rounded-lg p-6">
              <div className="flex items-center justify-between mb-4">
                <h3 className="text-xl font-bold text-red-400">SELL CALL</h3>
                <RecommendationBadge status={strategies.wheelStrategy.sellCall.recommendation} />
              </div>
              <div className="space-y-4">
                <div>
                  <p className="text-sm text-gray-400 mb-1">Reasoning</p>
                  <p className="text-gray-300">{strategies.wheelStrategy.sellCall.reasoning}</p>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Suggested Strike</p>
                    <p className="text-lg font-semibold">${strategies.wheelStrategy.sellCall.suggestedStrikePrice}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Target Delta</p>
                    <p className="text-lg font-semibold">{strategies.wheelStrategy.sellCall.targetDelta}</p>
                  </div>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Estimated Premium</p>
                    <p className="text-lg font-semibold">${strategies.wheelStrategy.sellCall.estimatedPremium}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Assignment Risk</p>
                    <p className={`text-lg font-semibold ${strategies.wheelStrategy.sellCall.assignmentRisk === 'LOW' ? 'text-green-400' : strategies.wheelStrategy.sellCall.assignmentRisk === 'MEDIUM' ? 'text-amber-400' : 'text-red-400'}`}>
                      {strategies.wheelStrategy.sellCall.assignmentRisk}
                    </p>
                  </div>
                </div>
                <div className="pt-4 border-t border-white/10">
                  <ConfidenceBadge level={strategies.wheelStrategy.sellCall.confidenceLevel} />
                </div>
              </div>
            </div>
          </div>
        )}

        {activeTab === 'directional' && (
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <div className="bg-gradient-to-br from-green-900/20 to-green-900/5 border border-green-900/30 rounded-lg p-6">
              <div className="flex items-center justify-between mb-4">
                <h3 className="text-xl font-bold text-green-400">BUY CALL</h3>
                <RecommendationBadge status={strategies.directionalPlays.buyCall.recommendation} />
              </div>
              <div className="space-y-4">
                <div>
                  <p className="text-sm text-gray-400 mb-1">Reasoning</p>
                  <p className="text-gray-300">{strategies.directionalPlays.buyCall.reasoning}</p>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Suggested Strike</p>
                    <p className="text-lg font-semibold">${strategies.directionalPlays.buyCall.suggestedStrikePrice}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Expiration</p>
                    <p className="text-lg font-semibold">{strategies.directionalPlays.buyCall.expirationTimeframe}</p>
                  </div>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Breakeven Price</p>
                    <p className="text-lg font-semibold">${strategies.directionalPlays.buyCall.breakevenPrice}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Max Risk</p>
                    <p className="text-lg font-semibold text-red-400">${strategies.directionalPlays.buyCall.maxRisk}</p>
                  </div>
                </div>
                <div className="pt-4 border-t border-white/10">
                  <ConfidenceBadge level={strategies.directionalPlays.buyCall.confidenceLevel} />
                </div>
              </div>
            </div>

            <div className="bg-gradient-to-br from-red-900/20 to-red-900/5 border border-red-900/30 rounded-lg p-6">
              <div className="flex items-center justify-between mb-4">
                <h3 className="text-xl font-bold text-red-400">BUY PUT</h3>
                <RecommendationBadge status={strategies.directionalPlays.buyPut.recommendation} />
              </div>
              <div className="space-y-4">
                <div>
                  <p className="text-sm text-gray-400 mb-1">Reasoning</p>
                  <p className="text-gray-300">{strategies.directionalPlays.buyPut.reasoning}</p>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Suggested Strike</p>
                    <p className="text-lg font-semibold">${strategies.directionalPlays.buyPut.suggestedStrikePrice}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Expiration</p>
                    <p className="text-lg font-semibold">{strategies.directionalPlays.buyPut.expirationTimeframe}</p>
                  </div>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Breakeven Price</p>
                    <p className="text-lg font-semibold">${strategies.directionalPlays.buyPut.breakevenPrice}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Max Risk</p>
                    <p className="text-lg font-semibold text-red-400">${strategies.directionalPlays.buyPut.maxRisk}</p>
                  </div>
                </div>
                <div className="pt-4 border-t border-white/10">
                  <ConfidenceBadge level={strategies.directionalPlays.buyPut.confidenceLevel} />
                </div>
              </div>
            </div>
          </div>
        )}

        {activeTab === 'spreads' && (
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
            <div className="bg-gradient-to-br from-green-900/20 to-green-900/5 border border-green-900/30 rounded-lg p-6">
              <div className="flex items-center justify-between mb-4">
                <h3 className="text-xl font-bold text-green-400">BULL PUT SPREAD</h3>
                <RecommendationBadge status={strategies.creditSpreads.bullPutSpread.recommendation} />
              </div>
              <div className="space-y-4">
                <div>
                  <p className="text-sm text-gray-400 mb-1">Reasoning</p>
                  <p className="text-gray-300">{strategies.creditSpreads.bullPutSpread.reasoning}</p>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Short Strike (Sell)</p>
                    <p className="text-lg font-semibold">${strategies.creditSpreads.bullPutSpread.shortStrike}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Long Strike (Buy)</p>
                    <p className="text-lg font-semibold">${strategies.creditSpreads.bullPutSpread.longStrike}</p>
                  </div>
                </div>
                <div className="grid grid-cols-3 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Max Profit</p>
                    <p className="text-lg font-semibold text-green-400">${strategies.creditSpreads.bullPutSpread.maxProfit}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Max Loss</p>
                    <p className="text-lg font-semibold text-red-400">${strategies.creditSpreads.bullPutSpread.maxLoss}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Breakeven</p>
                    <p className="text-lg font-semibold">${strategies.creditSpreads.bullPutSpread.breakevenPrice}</p>
                  </div>
                </div>
                <div className="pt-4 border-t border-white/10">
                  <ConfidenceBadge level={strategies.creditSpreads.bullPutSpread.confidenceLevel} />
                </div>
              </div>
            </div>

            <div className="bg-gradient-to-br from-red-900/20 to-red-900/5 border border-red-900/30 rounded-lg p-6">
              <div className="flex items-center justify-between mb-4">
                <h3 className="text-xl font-bold text-red-400">BEAR CALL SPREAD</h3>
                <RecommendationBadge status={strategies.creditSpreads.bearCallSpread.recommendation} />
              </div>
              <div className="space-y-4">
                <div>
                  <p className="text-sm text-gray-400 mb-1">Reasoning</p>
                  <p className="text-gray-300">{strategies.creditSpreads.bearCallSpread.reasoning}</p>
                </div>
                <div className="grid grid-cols-2 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Short Strike (Sell)</p>
                    <p className="text-lg font-semibold">${strategies.creditSpreads.bearCallSpread.shortStrike}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Long Strike (Buy)</p>
                    <p className="text-lg font-semibold">${strategies.creditSpreads.bearCallSpread.longStrike}</p>
                  </div>
                </div>
                <div className="grid grid-cols-3 gap-4">
                  <div>
                    <p className="text-sm text-gray-400">Max Profit</p>
                    <p className="text-lg font-semibold text-green-400">${strategies.creditSpreads.bearCallSpread.maxProfit}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Max Loss</p>
                    <p className="text-lg font-semibold text-red-400">${strategies.creditSpreads.bearCallSpread.maxLoss}</p>
                  </div>
                  <div>
                    <p className="text-sm text-gray-400">Breakeven</p>
                    <p className="text-lg font-semibold">${strategies.creditSpreads.bearCallSpread.breakevenPrice}</p>
                  </div>
                </div>
                <div className="pt-4 border-t border-white/10">
                  <ConfidenceBadge level={strategies.creditSpreads.bearCallSpread.confidenceLevel} />
                </div>
              </div>
            </div>
          </div>
        )}
      </div>
    </div>
  );
};

export default StrategyTabs;