<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* AppVulnerabilityMobileApp File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Beta\Microsoft\Graph\Model;

/**
* AppVulnerabilityMobileApp class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class AppVulnerabilityMobileApp extends Entity
{
    /**
    * Gets the createdDateTime
    * The created date.
    *
    * @return \DateTime|null The createdDateTime
    */
    public function getCreatedDateTime()
    {
        if (array_key_exists("createdDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["createdDateTime"], "\DateTime") || is_null($this->_propDict["createdDateTime"])) {
                return $this->_propDict["createdDateTime"];
            } else {
                $this->_propDict["createdDateTime"] = new \DateTime($this->_propDict["createdDateTime"]);
                return $this->_propDict["createdDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the createdDateTime
    * The created date.
    *
    * @param \DateTime $val The createdDateTime
    *
    * @return AppVulnerabilityMobileApp
    */
    public function setCreatedDateTime($val)
    {
        $this->_propDict["createdDateTime"] = $val;
        return $this;
    }

    /**
    * Gets the displayName
    * The device name.
    *
    * @return string|null The displayName
    */
    public function getDisplayName()
    {
        if (array_key_exists("displayName", $this->_propDict)) {
            return $this->_propDict["displayName"];
        } else {
            return null;
        }
    }

    /**
    * Sets the displayName
    * The device name.
    *
    * @param string $val The displayName
    *
    * @return AppVulnerabilityMobileApp
    */
    public function setDisplayName($val)
    {
        $this->_propDict["displayName"] = $val;
        return $this;
    }

    /**
    * Gets the lastModifiedDateTime
    * The last modified date.
    *
    * @return \DateTime|null The lastModifiedDateTime
    */
    public function getLastModifiedDateTime()
    {
        if (array_key_exists("lastModifiedDateTime", $this->_propDict)) {
            if (is_a($this->_propDict["lastModifiedDateTime"], "\DateTime") || is_null($this->_propDict["lastModifiedDateTime"])) {
                return $this->_propDict["lastModifiedDateTime"];
            } else {
                $this->_propDict["lastModifiedDateTime"] = new \DateTime($this->_propDict["lastModifiedDateTime"]);
                return $this->_propDict["lastModifiedDateTime"];
            }
        }
        return null;
    }

    /**
    * Sets the lastModifiedDateTime
    * The last modified date.
    *
    * @param \DateTime $val The lastModifiedDateTime
    *
    * @return AppVulnerabilityMobileApp
    */
    public function setLastModifiedDateTime($val)
    {
        $this->_propDict["lastModifiedDateTime"] = $val;
        return $this;
    }

    /**
    * Gets the mobileAppId
    * The Intune mobile app ID.
    *
    * @return string|null The mobileAppId
    */
    public function getMobileAppId()
    {
        if (array_key_exists("mobileAppId", $this->_propDict)) {
            return $this->_propDict["mobileAppId"];
        } else {
            return null;
        }
    }

    /**
    * Sets the mobileAppId
    * The Intune mobile app ID.
    *
    * @param string $val The mobileAppId
    *
    * @return AppVulnerabilityMobileApp
    */
    public function setMobileAppId($val)
    {
        $this->_propDict["mobileAppId"] = $val;
        return $this;
    }

    /**
    * Gets the mobileAppType
    * The app type.
    *
    * @return string|null The mobileAppType
    */
    public function getMobileAppType()
    {
        if (array_key_exists("mobileAppType", $this->_propDict)) {
            return $this->_propDict["mobileAppType"];
        } else {
            return null;
        }
    }

    /**
    * Sets the mobileAppType
    * The app type.
    *
    * @param string $val The mobileAppType
    *
    * @return AppVulnerabilityMobileApp
    */
    public function setMobileAppType($val)
    {
        $this->_propDict["mobileAppType"] = $val;
        return $this;
    }

    /**
    * Gets the version
    * The app version.
    *
    * @return string|null The version
    */
    public function getVersion()
    {
        if (array_key_exists("version", $this->_propDict)) {
            return $this->_propDict["version"];
        } else {
            return null;
        }
    }

    /**
    * Sets the version
    * The app version.
    *
    * @param string $val The version
    *
    * @return AppVulnerabilityMobileApp
    */
    public function setVersion($val)
    {
        $this->_propDict["version"] = $val;
        return $this;
    }

}
